/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.asset.common.DebtClassEnum;
import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.event.common.Trade;
import cdm.legaldocumentation.common.ContractualSupplementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeAdditionalFixedPaymentsMortgages")
@ImplementedBy(value=Default.class)
public interface TradeAdditionalFixedPaymentsMortgages
extends Validator<Trade> {
    public static final String NAME = "TradeAdditionalFixedPaymentsMortgages";
    public static final String DEFINITION = "if ((product -> economicTerms -> payout -> CreditDefaultPayout -> generalTerms -> referenceInformation -> referenceObligation -> security -> instrumentType any = InstrumentTypeEnum -> Debt and product -> economicTerms -> payout -> CreditDefaultPayout -> generalTerms -> referenceInformation -> referenceObligation -> security -> debtType -> debtClass any = DebtClassEnum -> AssetBacked) or contractDetails -> documentation -> legalAgreementIdentification -> agreementName -> contractualTermsSupplement -> contractualTermsSupplementType contains ContractualSupplementTypeEnum -> CDSonMBS) and product -> economicTerms -> payout -> CreditDefaultPayout -> protectionTerms -> floatingAmountEvents exists then (product -> economicTerms -> payout -> CreditDefaultPayout -> protectionTerms -> floatingAmountEvents -> additionalFixedPayments -> interestShortfallReimbursement exists and product -> economicTerms -> payout -> CreditDefaultPayout -> protectionTerms -> floatingAmountEvents -> additionalFixedPayments -> principalShortfallReimbursement exists and product -> economicTerms -> payout -> CreditDefaultPayout -> protectionTerms -> floatingAmountEvents -> additionalFixedPayments -> writedownReimbursement exists)";

    public static class NoOp
    implements TradeAdditionalFixedPaymentsMortgages {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeAdditionalFixedPaymentsMortgages {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeAdditionalFixedPaymentsMortgages.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeAdditionalFixedPaymentsMortgages.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeAdditionalFixedPaymentsMortgages.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeAdditionalFixedPaymentsMortgages.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getInstrumentType", security -> security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.DEBT)), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()).map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).map("getDebtType", security -> security.getDebtType()).map("getDebtClass", debtType -> debtType.getDebtClass()), (Mapper)MapperS.of((Object)((Object)DebtClassEnum.ASSET_BACKED)), (CardinalityOperator)CardinalityOperator.Any)).or(ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getLegalAgreementIdentification", legalAgreement -> legalAgreement.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).mapC("getContractualTermsSupplement", agreementName -> agreementName.getContractualTermsSupplement()).map("getContractualTermsSupplementType", contractualTermsSupplement -> contractualTermsSupplement.getContractualTermsSupplementType()).map("Type coercion", fieldWithMetaContractualSupplementTypeEnum -> fieldWithMetaContractualSupplementTypeEnum.getValue()), (Mapper)MapperS.of((Object)((Object)ContractualSupplementTypeEnum.CD_SON_MBS)))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getFloatingAmountEvents", protectionTerms -> protectionTerms.getFloatingAmountEvents()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getFloatingAmountEvents", protectionTerms -> protectionTerms.getFloatingAmountEvents()).map("getAdditionalFixedPayments", floatingAmountEvents -> floatingAmountEvents.getAdditionalFixedPayments()).map("getInterestShortfallReimbursement", additionalFixedPayments -> additionalFixedPayments.getInterestShortfallReimbursement())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getFloatingAmountEvents", protectionTerms -> protectionTerms.getFloatingAmountEvents()).map("getAdditionalFixedPayments", floatingAmountEvents -> floatingAmountEvents.getAdditionalFixedPayments()).map("getPrincipalShortfallReimbursement", additionalFixedPayments -> additionalFixedPayments.getPrincipalShortfallReimbursement()))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getFloatingAmountEvents", protectionTerms -> protectionTerms.getFloatingAmountEvents()).map("getAdditionalFixedPayments", floatingAmountEvents -> floatingAmountEvents.getAdditionalFixedPayments()).map("getWritedownReimbursement", additionalFixedPayments -> additionalFixedPayments.getWritedownReimbursement())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

