/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.processor;

import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenUnitsMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenUnitsMappingProcessor.class);

    public OpenUnitsMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public <T> void mapBasic(Path openUnitPath, Optional<T> instance, RosettaModelObjectBuilder parent) {
        UnitType.UnitTypeBuilder unitTypeBuilder = (UnitType.UnitTypeBuilder)parent;
        MappingProcessorUtils.subPath((String)"singleUnderlyer", (Path)openUnitPath).ifPresent(singleUnderlyerPath -> {
            List<Mapping> singleUnderlyerMappings = this.getMappings().stream().filter(m -> singleUnderlyerPath.fullStartMatches(m.getXmlPath())).collect(Collectors.toList());
            this.setQuantityUnit(unitTypeBuilder, singleUnderlyerPath.addElement("equity"), FinancialUnitEnum.SHARE, singleUnderlyerMappings);
            this.setQuantityUnit(unitTypeBuilder, singleUnderlyerPath.addElement("bond"), FinancialUnitEnum.SHARE, singleUnderlyerMappings);
            this.setQuantityUnit(unitTypeBuilder, singleUnderlyerPath.addElement("index"), FinancialUnitEnum.INDEX_UNIT, singleUnderlyerMappings);
            this.setQuantityUnit(unitTypeBuilder, singleUnderlyerPath.addElement("commodity"), FinancialUnitEnum.WEIGHT, singleUnderlyerMappings);
        });
        MappingProcessorUtils.subPath((String)"basketConstituent", (Path)openUnitPath).ifPresent(basketConsitutentPath -> {
            List<Mapping> basketConstituentMappings = this.getMappings().stream().filter(m -> basketConsitutentPath.fullStartMatches(m.getXmlPath())).collect(Collectors.toList());
            LOGGER.debug("Found {} mappings in path {}", (Object)basketConstituentMappings.size(), basketConsitutentPath);
            this.setQuantityUnit(unitTypeBuilder, basketConsitutentPath.addElement("equity"), FinancialUnitEnum.SHARE, basketConstituentMappings);
            this.setQuantityUnit(unitTypeBuilder, basketConsitutentPath.addElement("bond"), FinancialUnitEnum.SHARE, basketConstituentMappings);
            this.setQuantityUnit(unitTypeBuilder, basketConsitutentPath.addElement("index"), FinancialUnitEnum.INDEX_UNIT, basketConstituentMappings);
            this.setQuantityUnit(unitTypeBuilder, basketConsitutentPath.addElement("commodity"), FinancialUnitEnum.WEIGHT, basketConstituentMappings);
            if (unitTypeBuilder.getFinancialUnit() == null) {
                unitTypeBuilder.setFinancialUnit(FinancialUnitEnum.WEIGHT);
            }
        });
    }

    private void setQuantityUnit(UnitType.UnitTypeBuilder unitTypeBuilder, Path synonymPath, FinancialUnitEnum financialUnit, List<Mapping> filteredMappings) {
        MappingProcessorUtils.getNonNullMappedValue(filteredMappings, (Path)synonymPath, (String[])new String[0]).ifPresent(x -> {
            LOGGER.debug("Setting openUnits FinancialUnitEnum {} based on path {}", (Object)financialUnit, (Object)synonymPath);
            unitTypeBuilder.setFinancialUnit(financialUnit);
        });
    }
}

