/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.functions.DateDifference;
import cdm.base.datetime.functions.LeapYearDateDifference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=DateDifferenceYearsDefault.class)
public abstract class DateDifferenceYears
implements RosettaFunction {
    @Inject
    protected DateDifference dateDifference;
    @Inject
    protected LeapYearDateDifference leapYearDateDifference;

    public BigDecimal evaluate(Date firstDate, Date secondDate) {
        BigDecimal difference = this.doEvaluate(firstDate, secondDate);
        return difference;
    }

    protected abstract BigDecimal doEvaluate(Date var1, Date var2);

    protected abstract MapperS<Integer> totalDays(Date var1, Date var2);

    protected abstract MapperS<Integer> leapYearDays(Date var1, Date var2);

    protected abstract MapperS<Integer> nonLeapYearDays(Date var1, Date var2);

    public static class DateDifferenceYearsDefault
    extends DateDifferenceYears {
        @Override
        protected BigDecimal doEvaluate(Date firstDate, Date secondDate) {
            BigDecimal difference = null;
            return this.assignOutput(difference, firstDate, secondDate);
        }

        protected BigDecimal assignOutput(BigDecimal difference, Date firstDate, Date secondDate) {
            difference = (BigDecimal)MapperMaths.add((Mapper)MapperMaths.divide((Mapper)this.nonLeapYearDays(firstDate, secondDate).map("Type coercion", integer0 -> integer0 == null ? null : BigDecimal.valueOf(integer0.intValue())), (Mapper)MapperS.of((Object)new BigDecimal("365.0"))), (Mapper)MapperMaths.divide((Mapper)this.leapYearDays(firstDate, secondDate).map("Type coercion", integer1 -> integer1 == null ? null : BigDecimal.valueOf(integer1.intValue())), (Mapper)MapperS.of((Object)new BigDecimal("366.0")))).get();
            return difference;
        }

        @Override
        protected MapperS<Integer> totalDays(Date firstDate, Date secondDate) {
            return MapperS.of((Object)this.dateDifference.evaluate(firstDate, secondDate));
        }

        @Override
        protected MapperS<Integer> leapYearDays(Date firstDate, Date secondDate) {
            return MapperS.of((Object)this.leapYearDateDifference.evaluate(firstDate, secondDate));
        }

        @Override
        protected MapperS<Integer> nonLeapYearDays(Date firstDate, Date secondDate) {
            return MapperMaths.subtract(this.totalDays(firstDate, secondDate), this.leapYearDays(firstDate, secondDate));
        }
    }
}

