# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['TradableProduct']


class TradableProduct(BaseDataClass):
    """
    Definition of a product as ready to be traded, i.e. included in an execution or contract, by associating a specific price and quantity to this product plus an (optional) mechanism for any potential future quantity adjustment.
    """
    product: cdm.product.template.NonTransferableProduct.NonTransferableProduct = Field(..., description="The underlying product to be included in a contract or execution.")
    """
    The underlying product to be included in a contract or execution.
    """
    tradeLot: List[cdm.product.template.TradeLot.TradeLot] = Field([], description="Specifies the price, quantity and effective date of each trade lot, when the same product may be traded multiple times in different lots with the same counterparty. In a trade increase, a new trade lot is added to the list, with the corresponding effective date. In a trade decrease, the existing trade lot(s) are decreased of the corresponding quantity (and an unwind fee may have to be settled). The multiple cardinality and the ability to increase existing trades is used for Equity Swaps in particular.")
    """
    Specifies the price, quantity and effective date of each trade lot, when the same product may be traded multiple times in different lots with the same counterparty. In a trade increase, a new trade lot is added to the list, with the corresponding effective date. In a trade decrease, the existing trade lot(s) are decreased of the corresponding quantity (and an unwind fee may have to be settled). The multiple cardinality and the ability to increase existing trades is used for Equity Swaps in particular.
    """
    @rosetta_condition
    def cardinality_tradeLot(self):
        return check_cardinality(self.tradeLot, 1, None)
    
    counterparty: List[cdm.base.staticdata.party.Counterparty.Counterparty] = Field([], description="Specifies the parties which are the two counterparties to the transaction. The product is agnostic to the actual parties to the transaction, with the party references abstracted away from the product definition and replaced by the counterparty enum (e.g. CounterpartyEnum values Party1 or Party2). The counterparty enum can then be positioned in the product (e.g. to specify which counterparty is the payer, receiver etc) and this counterparties attribute, which is positioned outside of the product definition, allows the counterparty enum to be associated with an actual party reference.")
    """
    Specifies the parties which are the two counterparties to the transaction.  The product is agnostic to the actual parties to the transaction, with the party references abstracted away from the product definition and replaced by the counterparty enum (e.g. CounterpartyEnum values Party1 or Party2). The counterparty enum can then be positioned in the product (e.g. to specify which counterparty is the payer, receiver etc) and this counterparties attribute, which is positioned outside of the product definition, allows the counterparty enum to be associated with an actual party reference.
    """
    @rosetta_condition
    def cardinality_counterparty(self):
        return check_cardinality(self.counterparty, 2, None)
    
    ancillaryParty: List[cdm.base.staticdata.party.AncillaryParty.AncillaryParty] = Field([], description="Specifies the parties with ancillary roles in the transaction. The product is agnostic to the actual parties involved in the transaction, with the party references abstracted away from the product definition and replaced by the AncillaryRoleEnum. The AncillaryRoleEnum can then be positioned in the product and this AncillaryParty type, which is positioned outside of the product definition, allows the AncillaryRoleEnum to be associated with an actual party reference.")
    """
    Specifies the parties with ancillary roles in the transaction. The product is agnostic to the actual parties involved in the transaction, with the party references abstracted away from the product definition and replaced by the AncillaryRoleEnum. The AncillaryRoleEnum can then be positioned in the product and this AncillaryParty type, which is positioned outside of the product definition, allows the AncillaryRoleEnum to be associated with an actual party reference.
    """
    adjustment: Optional[cdm.product.common.NotionalAdjustmentEnum.NotionalAdjustmentEnum] = Field(None, description="Specifies the conditions that govern the adjustment to the quantity of a product being traded: e.g. execution, portfolio rebalancing etc. It is typically used in the context of Equity Swaps.")
    """
    Specifies the conditions that govern the adjustment to the quantity of a product being traded: e.g. execution, portfolio rebalancing etc. It is typically used in the context of Equity Swaps.
    """
    
    @rosetta_condition
    def condition_0_PriceQuantityTriangulation(self):
        """
        Check PriceQuantity triangulation for each TradeLot.
        """
        item = self
        return all_elements(PriceQuantityTriangulation(rosetta_resolve_attr(self, "tradeLot")), "=", True)
    
    @rosetta_condition
    def condition_1_NotionalAdjustment(self):
        """
        As the adjustment attribute applies to return swaps, the equity payout needs to be present alongside it.
        """
        item = self
        def _then_fn0():
            return (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "PerformancePayout"), "returnTerms"), "priceReturnTerms")) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "PerformancePayout")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "adjustment")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_PerformancePayout_ExtraordinaryDividendsParty(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "PerformancePayout"), "returnTerms"), "dividendReturnTerms"), "extraordinaryDividendsParty"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXTRAORDINARY_DIVIDENDS_PARTY")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXTRAORDINARY_DIVIDENDS_PARTY")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "PerformancePayout"), "returnTerms"), "dividendReturnTerms"), "extraordinaryDividendsParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_OptionPayout_PredeterminedClearingOrganizationParty(self):
        item = self
        def _then_fn0():
            return contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "PREDETERMINED_CLEARING_ORGANIZATION_PARTY"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "OptionPayout"), "settlementTerms"), "physicalSettlementTerms"), "predeterminedClearingOrganizationParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_4_ForwardPayout_PredeterminedClearingOrganizationParty(self):
        item = self
        def _then_fn0():
            return contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "PREDETERMINED_CLEARING_ORGANIZATION_PARTY"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "SettlementPayout"), "settlementTerms"), "physicalSettlementTerms"), "predeterminedClearingOrganizationParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_5_PredeterminedClearingOrganizationParty(self):
        item = self
        def _then_fn0():
            return (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "SettlementPayout"), "settlementTerms"), "physicalSettlementTerms"), "predeterminedClearingOrganizationParty")) or rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "OptionPayout"), "settlementTerms"), "physicalSettlementTerms"), "predeterminedClearingOrganizationParty")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "PREDETERMINED_CLEARING_ORGANIZATION_PARTY")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_6_ExerciseNoticeReceiverPartyManual(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "OptionPayout"), "exerciseTerms"), "exerciseProcedure"), "manualExercise"), "exerciseNotice"), "exerciseNoticeReceiver"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_MANUAL")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_MANUAL")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "OptionPayout"), "exerciseTerms"), "exerciseProcedure"), "manualExercise"), "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_7_ExerciseNoticeReceiverPartyOptionalEarlyTermination(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "earlyTerminationProvision"), "optionalEarlyTermination"), "exerciseNotice"), "exerciseNoticeReceiver"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_OPTIONAL_EARLY_TERMINATION")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_OPTIONAL_EARLY_TERMINATION")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "earlyTerminationProvision"), "optionalEarlyTermination"), "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_8_ExerciseNoticeReceiverPartyCancelableProvision(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "cancelableProvision"), "exerciseNotice"), "exerciseNoticeReceiver"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_CANCELABLE_PROVISION")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_CANCELABLE_PROVISION")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "cancelableProvision"), "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_9_ExerciseNoticeReceiverPartyExtendibleProvision(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "extendibleProvision"), "exerciseNotice"), "exerciseNoticeReceiver"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_EXTENDIBLE_PROVISION")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_EXTENDIBLE_PROVISION")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "extendibleProvision"), "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_10_CalculationAgentIndependent(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "calculationAgent"), "calculationAgentParty"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_INDEPENDENT")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_INDEPENDENT")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_11_CalculationAgentOptionalEarlyTermination(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "earlyTerminationProvision"), "optionalEarlyTermination"), "calculationAgent"), "calculationAgentParty"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_OPTIONAL_EARLY_TERMINATION")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_OPTIONAL_EARLY_TERMINATION")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "earlyTerminationProvision"), "optionalEarlyTermination"), "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_12_CalculationAgentMandatoryEarlyTermination(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "earlyTerminationProvision"), "mandatoryEarlyTermination"), "calculationAgent"), "calculationAgentParty"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_MANDATORY_EARLY_TERMINATION")) and if_cond_fn(contains(rosetta_resolve_attr(rosetta_resolve_attr(self, "ancillaryParty"), "role"), rosetta_resolve_attr(AncillaryRoleEnum, "CALCULATION_AGENT_MANDATORY_EARLY_TERMINATION")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "terminationProvision"), "earlyTerminationProvision"), "mandatoryEarlyTermination"), "calculationAgent"), "calculationAgentParty")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.NonTransferableProduct
import cdm.product.template.TradeLot
import cdm.base.staticdata.party.Counterparty
import cdm.base.staticdata.party.AncillaryParty
import cdm.product.common.NotionalAdjustmentEnum
from cdm.product.template.functions.PriceQuantityTriangulation import PriceQuantityTriangulation
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
