# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OptionPayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class OptionPayout(PayoutBase):
    """
     The option payout specification terms. The associated globalKey denotes the ability to associate a hash value to the respective OptionPayout instantiation for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    """
    buyerSeller: cdm.base.staticdata.party.BuyerSeller.BuyerSeller = Field(..., description="")
    feature: Optional[cdm.product.template.OptionFeature.OptionFeature] = Field(None, description="The option feature, such as quanto, Asian, barrier, knock.")
    """
    The option feature, such as quanto, Asian, barrier, knock.
    """
    observationTerms: Optional[cdm.product.common.schedule.ObservationTerms.ObservationTerms] = Field(None, description="Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. To be used for option contracts that reference a benchmark price.")
    """
    Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. To be used for option contracts that reference a benchmark price.
    """
    schedule: Optional[cdm.product.template.CalculationSchedule.CalculationSchedule] = Field(None, description="Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.")
    """
    Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
    """
    delivery: Optional[cdm.product.asset.AssetDeliveryInformation.AssetDeliveryInformation] = Field(None, description="Contains the information relative to the delivery of the asset.")
    """
    Contains the information relative to the delivery of the asset.
    """
    underlier: cdm.product.template.Underlier.Underlier = Field(..., description="The financial product underlying the option, which can be of any type including an Asset, Basket, Index or a NonTransferableProduct.")
    """
    The financial product underlying the option, which can be of any type including an Asset, Basket, Index or a NonTransferableProduct.
    """
    optionType: Optional[cdm.product.template.OptionTypeEnum.OptionTypeEnum] = Field(None, description="The type of option transaction. From a usage standpoint, put/call is the default option type, while payer/receiver indicator is used for options on index credit default swaps, consistently with the industry practice. Straddle is used for the case of straddle strategy, that combine a call and a put with the same strike.")
    """
    The type of option transaction. From a usage standpoint, put/call is the default option type, while payer/receiver indicator is used for options on index credit default swaps, consistently with the industry practice. Straddle is used for the case of straddle strategy, that combine a call and a put with the same strike.
    """
    exerciseTerms: cdm.product.template.ExerciseTerms.ExerciseTerms = Field(..., description="The terms for exercising the option, which include the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).")
    """
    The terms for exercising the option, which include the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).
    """
    strike: Optional[cdm.product.template.OptionStrike.OptionStrike] = Field(None, description="Specifies the strike of the option")
    """
    Specifies the strike of the option
    """
    
    @rosetta_condition
    def condition_0_ClearedPhysicalSettlementExists(self):
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementTerms"), "physicalSettlementTerms"), "clearedPhysicalSettlement"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementTerms"), "physicalSettlementTerms")) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "InterestRatePayout"))) and all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_deep_attr(self, "economicTerms"), "payout"), "InterestRatePayout")), "=", 2)), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_DeliveryCapacity(self):
        """
        Checks that only one of the representations of delivery capacity is present simultaneously.
        """
        item = self
        def _then_fn3():
            return (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn3():
            return True
        
        def _then_fn2():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn2():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity")), _then_fn3, _else_fn3)
        
        def _then_fn1():
            return (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn1():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")), _then_fn2, _else_fn2)
        
        def _then_fn0():
            return (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "deliveryCapacity")))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "deliveryCapacity"))))
        
        def _else_fn0():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "deliveryCapacity")), _then_fn1, _else_fn1)
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "deliveryCapacity")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_PriceTimeIntervalQuantity(self):
        """
        Checks that only one of the representations of price time interval quantity is present simultaneously.
        """
        item = self
        def _then_fn2():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity"))))
        
        def _else_fn2():
            return True
        
        def _then_fn1():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity"))))
        
        def _else_fn1():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity")), _then_fn2, _else_fn2)
        
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "profile"), "block"), "priceTimeIntervalQuantity"))))
        
        def _else_fn0():
            return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "delivery"), "periods"), "profile"), "block"), "priceTimeIntervalQuantity")), _then_fn1, _else_fn1)
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "schedule"), "schedulePeriod"), "deliveryPeriod"), "priceTimeIntervalQuantity")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_OptionStylePresent(self):
        """
        This condition ensures that an optionPayout contains the style of option within its exercise terms.
        """
        item = self
        return rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseTerms"), "style"))
    
    @rosetta_condition
    def condition_4_OptionTypePresent(self):
        """
        This condition ensures that an option type is set when the underlier is not a non-transferable product.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "optionType"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "underlier"), "Product"), "NonTransferableProduct"))), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.BuyerSeller
import cdm.product.template.OptionFeature
import cdm.product.common.schedule.ObservationTerms
import cdm.product.template.CalculationSchedule
import cdm.product.asset.AssetDeliveryInformation
import cdm.product.template.Underlier
import cdm.product.template.OptionTypeEnum
import cdm.product.template.ExerciseTerms
import cdm.product.template.OptionStrike
