# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FixedPricePayout']

from cdm.product.common.settlement.PayoutBase import PayoutBase

class FixedPricePayout(PayoutBase):
    """
    Represents a fixed price payout. There is no underlier associated with this payout type and is based on fixed pricing per a given unit (e.g. in commodities price per barrel)
    """
    paymentDates: cdm.product.common.schedule.PaymentDates.PaymentDates = Field(..., description="Specifies the parameters to generate the payment date schedule, either through a parametric representation or by reference to specified dates.")
    """
    Specifies the parameters to generate the payment date schedule, either through a parametric representation or by reference to specified dates.
    """
    fixedPrice: cdm.product.common.settlement.FixedPrice.FixedPrice = Field(..., description="Specifies the fixed price on which fixed forward payments are based.")
    """
    Specifies the fixed price on which fixed forward payments are based.
    """
    schedule: Optional[cdm.product.template.CalculationSchedule.CalculationSchedule] = Field(None, description="Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.")
    """
    Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
    """
    
    @rosetta_condition
    def condition_0_Quantity(self):
        """
        When there is an OptionPayout the quantity can be expressed as part of the payoutQuantity, or as part of the underlier in the case of a Swaption.  For all other payouts that extend PayoutBase the payoutQuantity is a mandatory attribute.
        """
        item = self
        return rosetta_attr_exists(rosetta_resolve_attr(self, "priceQuantity"))

import cdm 
import cdm.product.common.schedule.PaymentDates
import cdm.product.common.settlement.FixedPrice
import cdm.product.template.CalculationSchedule
