# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CancelableProvision']

from cdm.base.staticdata.party.BuyerSeller import BuyerSeller

class CancelableProvision(BuyerSeller):
    """
    A data defining:  the right of a party to cancel a swap transaction on the specified exercise dates. The provision is for 'walk-away' cancellation (i.e. the fair value of the swap is not paid). A fee payable on exercise can be specified. As a difference from the FpML construct, the canonical model extends the BuyerSeller class.
    """
    exerciseNotice: Optional[cdm.product.template.ExerciseNotice.ExerciseNotice] = Field(None, description="Definition of the party to whom notice of exercise should be given.")
    """
    Definition of the party to whom notice of exercise should be given.
    """
    followUpConfirmation: bool = Field(..., description="A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller's agent.")
    """
    A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller's agent.
    """
    cancelableProvisionAdjustedDates: Optional[cdm.product.template.CancelableProvisionAdjustedDates.CancelableProvisionAdjustedDates] = Field(None, description="The adjusted dates associated with a cancelable provision. These dates have been adjusted for any applicable business day convention.")
    """
    The adjusted dates associated with a cancelable provision. These dates have been adjusted for any applicable business day convention.
    """
    finalCalculationPeriodDateAdjustment: List[cdm.product.common.schedule.FinalCalculationPeriodDateAdjustment.FinalCalculationPeriodDateAdjustment] = Field([], description="Business date convention adjustment to final payment period per leg (swapStream) upon exercise event. The adjustments can be made in-line with leg level BDC's or they can be specified separately.")
    """
    Business date convention adjustment to final payment period per leg (swapStream) upon exercise event. The adjustments can be made in-line with leg level BDC's or they can be specified separately.
    """
    initialFee: Optional[cdm.event.common.Transfer.Transfer] = Field(None, description="An initial fee for the cancelable option.")
    """
    An initial fee for the cancelable option.
    """
    callingParty: Optional[cdm.product.template.CallingPartyEnum.CallingPartyEnum] = Field(None, description="The party with right to exercise a cancellation. Allows for buyer, seller or either.")
    """
    The party with right to exercise a cancellation. Allows for buyer, seller or either.
    """
    earliestDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The first day when cancelation is permitted to take effect. A party may give notice prior to this date and taken together with the effective period would be necessary to cancel on this date.")
    """
    The first day when cancelation is permitted to take effect. A party may give notice prior to this date and taken together with the effective period would be necessary to cancel on this date.
    """
    expirationDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The last day within the term of the contract that cancelation is allowed.")
    """
    The last day within the term of the contract that cancelation is allowed.
    """
    effectiveDate: Optional[cdm.base.datetime.AdjustableOrRelativeDates.AdjustableOrRelativeDates] = Field(None, description="The effective date if cancelation is invoked otherwise the cancellation period defines the cancellation date.")
    """
    The effective date if cancelation is invoked otherwise the cancellation period defines the cancellation date.
    """
    effectivePeriod: Optional[cdm.base.datetime.Period.Period] = Field(None, description="Effective period for cancelation when notice is given. This is the period after notice is given that cancellation becomes effecticve.")
    """
    Effective period for cancelation when notice is given. This is the period after notice is given that cancellation becomes effecticve.
    """
    earliestCancellationTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The earliest time in a business day that notice of cancelation can be given.")
    """
    The earliest time in a business day that notice of cancelation can be given.
    """
    latestCancelationTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The latest time at which notice of cancelation can be given.")
    """
    The latest time at which notice of cancelation can be given.
    """
    exerciseTerms: cdm.product.template.ExerciseTerms.ExerciseTerms = Field(..., description="The exercise terms associated with the cancelable provision, including details such as exercise style, exercise fees, and any other relevant conditions or terms governing the cancellation of the swap transaction.")
    """
    The exercise terms associated with the cancelable provision, including details such as exercise style, exercise fees, and any other relevant conditions or terms governing the cancellation of the swap transaction.
    """
    
    @rosetta_condition
    def condition_0_EffectiveDate(self):
        """
        Must select one of predefined cancellation types of effectiveDate or effectivePeriod.
        """
        item = self
        return rosetta_check_one_of(self, 'effectiveDate', 'effectivePeriod', necessity=False)
    
    @rosetta_condition
    def condition_1_CancelableProvisionExerciseNoticeReceiverParty(self):
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver"), "=", rosetta_resolve_attr(AncillaryRoleEnum, "EXERCISE_NOTICE_RECEIVER_PARTY_CANCELABLE_PROVISION"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "exerciseNotice"), "exerciseNoticeReceiver")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.ExerciseNotice
import cdm.product.template.CancelableProvisionAdjustedDates
import cdm.product.common.schedule.FinalCalculationPeriodDateAdjustment
import cdm.event.common.Transfer
import cdm.product.template.CallingPartyEnum
import cdm.base.datetime.AdjustableOrRelativeDate
import cdm.base.datetime.AdjustableOrRelativeDates
import cdm.base.datetime.Period
import cdm.base.datetime.BusinessCenterTime
import cdm.product.template.ExerciseTerms
from cdm.base.staticdata.party.AncillaryRoleEnum import AncillaryRoleEnum
