# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.Qualify_InstrumentTypeEquity import Qualify_InstrumentTypeEquity
from cdm.base.staticdata.asset.common.AssetClassEnum import AssetClassEnum
from cdm.observable.asset.Observable import Observable

__all__ = ['Qualify_UnderlierObservable_Equity']


@replaceable
def Qualify_UnderlierObservable_Equity(observable: Observable) -> bool:
    """
    Qualifies an Observable as having the Asset Class classification Equity.
    
    Parameters 
    ----------
    observable : Observable
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    is_product =  ((Qualify_InstrumentTypeEquity(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Asset"), "Instrument")) or all_elements(rosetta_resolve_deep_attr(self, "assetClass"), "=", rosetta_resolve_attr(AssetClassEnum, "EQUITY"))) or (rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Basket")) and all_elements(list(map(lambda item: Qualify_UnderlierObservable_Equity(item), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "observable"), "Basket"), "basketConstituent"))), "=", True)))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
