# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.Qualify_EquitySwap_ParameterReturnDividend_Basket import Qualify_EquitySwap_ParameterReturnDividend_Basket
from cdm.product.template.EconomicTerms import EconomicTerms

__all__ = ['Qualify_EquityOption_ParameterReturnDividend_Basket']


@replaceable
def Qualify_EquityOption_ParameterReturnDividend_Basket(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as an Equity Dividend Basket Option.  The determination of the qualification is based on the economic terms and the following criteria: 1) The product contains a single option payout and 2) the underlying product is a Basket Equity Dividend Swap
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    underlierEconomicTerms = get_only_element(rosetta_resolve_deep_attr(self, "economicTerms"))
    is_product =  (rosetta_attr_exists(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout")), "OptionPayout")) and all_elements(Qualify_EquitySwap_ParameterReturnDividend_Basket(rosetta_resolve_attr(self, "underlierEconomicTerms")), "=", True))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
