# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ConcentrationLimit']


class ConcentrationLimit(BaseDataClass):
    """
    Represents a class to describe concentration limits that may be applicable to eligible collateral criteria.
    """
    concentrationLimitCriteria: Optional[cdm.product.collateral.ConcentrationLimitCriteria.ConcentrationLimitCriteria] = Field(None, description="Specifies a set of criteria to describe the assets that the concentration limits apply to.")
    """
    Specifies a set of criteria to describe the assets that the concentration limits apply to.
    """
    valueLimit: Optional[cdm.base.math.MoneyRange.MoneyRange] = Field(None, description="Specifies the value of collateral limit represented as a range.")
    """
    Specifies the value of collateral limit represented as a range.
    """
    percentageLimit: Optional[cdm.base.math.NumberRange.NumberRange] = Field(None, description="Specifies the perecentage of collateral limit represented as a decimal number - example 25% is 0.25.")
    """
    Specifies the perecentage of collateral limit represented as a decimal number - example 25% is 0.25.
    """
    
    @rosetta_condition
    def condition_0_ConcentrationLimitValueChoice(self):
        """
        Either a value or percentage concentration limit must be specified.
        """
        item = self
        return rosetta_check_one_of(self, 'valueLimit', 'percentageLimit', necessity=True)
    
    @rosetta_condition
    def condition_1_PercentageConcentrationLimit(self):
        """
        concentration limit must be described as a percentage.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "percentageLimit"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "concentrationLimitCriteria"), "concentrationLimitType"), "=", rosetta_resolve_attr(ConcentrationLimitTypeEnum, "MARKET_CAPITALISATION")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.collateral.ConcentrationLimitCriteria
import cdm.base.math.MoneyRange
import cdm.base.math.NumberRange
from cdm.product.collateral.ConcentrationLimitTypeEnum import ConcentrationLimitTypeEnum
