# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralCriteria']


class CollateralCriteria(BaseDataClass):
    """
    The possible different terms that can be combined, using AND, OR and NOT logic, to define the issuers and/or assets that meet a given criteria for collateral.
    """
    AllCriteria: Optional[cdm.product.collateral.AllCriteria.AllCriteria] = Field(None, description="Enables two or more Collateral Criteria to be combined using AND logic.")
    """
    Enables two or more Collateral Criteria to be combined using AND logic.
    """
    AnyCriteria: Optional[cdm.product.collateral.AnyCriteria.AnyCriteria] = Field(None, description="Enables two or more Collateral Criteria to be combined using OR logic.")
    """
    Enables two or more Collateral Criteria to be combined using OR logic.
    """
    NegativeCriteria: Optional[cdm.product.collateral.NegativeCriteria.NegativeCriteria] = Field(None, description="Enables a single Collateral Criteria to be excluded using NOT logic.")
    """
    Enables a single Collateral Criteria to be excluded using NOT logic.
    """
    CollateralIssuerType: Optional[cdm.base.staticdata.asset.common.CollateralIssuerType.CollateralIssuerType] = Field(None, description="Criteria is the type of entity issuing the asset.")
    """
    Criteria is the type of entity issuing the asset.
    """
    AssetType: Optional[cdm.base.staticdata.asset.common.AssetType.AssetType] = Field(None, description="Criteria is the asset type of the collateral.")
    """
    Criteria is the asset type of the collateral.
    """
    IssuerCountryOfOrigin: Optional[cdm.product.collateral.IssuerCountryOfOrigin.IssuerCountryOfOrigin] = Field(None, description="Criteria is the issuing entity country of origin.")
    """
    Criteria is the issuing entity country of origin.
    """
    AssetCountryOfOrigin: Optional[cdm.product.collateral.AssetCountryOfOrigin.AssetCountryOfOrigin] = Field(None, description="Criteria is the collateral asset country of origin.")
    """
    Criteria is the collateral asset country of origin.
    """
    CurrencyCodeEnum: Optional[cdm.base.staticdata.asset.common.CurrencyCodeEnum.CurrencyCodeEnum] = Field(None, description="Criteria is the denominated currency of the collateral.")
    """
    Criteria is the denominated currency of the collateral.
    """
    IssuerName: Optional[cdm.product.collateral.IssuerName.IssuerName] = Field(None, description="Criteria is a specific named issuer entity.")
    """
    Criteria is a specific named issuer entity.
    """
    IssuerAgencyRating: Optional[cdm.product.collateral.IssuerAgencyRating.IssuerAgencyRating] = Field(None, description="Criteria is the agency rating(s) of the issuer.")
    """
    Criteria is the agency rating(s) of the issuer.
    """
    SovereignAgencyRating: Optional[cdm.product.collateral.SovereignAgencyRating.SovereignAgencyRating] = Field(None, description="Criteria is the agency rating(s) of the country of the issuer.")
    """
    Criteria is the agency rating(s) of the country of the issuer.
    """
    AssetAgencyRating: Optional[cdm.product.collateral.AssetAgencyRating.AssetAgencyRating] = Field(None, description="Criteria is the agency rating(s) of the collateral asset.")
    """
    Criteria is the agency rating(s) of the collateral asset.
    """
    AssetMaturity: Optional[cdm.product.collateral.AssetMaturity.AssetMaturity] = Field(None, description="Criteria is the maturity characteristics of the collateral asset.")
    """
    Criteria is the maturity characteristics of the collateral asset.
    """
    SpecificAsset: Optional[cdm.product.collateral.SpecificAsset.SpecificAsset] = Field(None, description="Criteria is a specifically identified asset")
    """
    Criteria is a specifically identified asset
    """
    CollateralTaxonomy: Optional[cdm.base.staticdata.asset.common.CollateralTaxonomy.CollateralTaxonomy] = Field(None, description="Criteria is the taxonomy characteristics of an collateral.")
    """
    Criteria is the taxonomy characteristics of an collateral.
    """
    ListingExchange: Optional[cdm.product.collateral.ListingExchange.ListingExchange] = Field(None, description="Criteria is that the collateral is listed on a specific exchange.")
    """
    Criteria is that the collateral is listed on a specific exchange.
    """
    ListingSector: Optional[cdm.product.collateral.ListingSector.ListingSector] = Field(None, description="Criteria is the industry sector of the collateral asset.")
    """
    Criteria is the industry sector of the collateral asset.
    """
    Index: Optional[cdm.observable.asset.Index.Index] = Field(None, description="Criteria is that the collateral is a constituent of a specific index.")
    """
    Criteria is that the collateral is a constituent of a specific index.
    """
    CounterpartyOwnIssuePermitted: Optional[cdm.product.collateral.CounterpartyOwnIssuePermitted.CounterpartyOwnIssuePermitted] = Field(None, description="Criteria includes collateral issued by the counterparty.")
    """
    Criteria includes collateral issued by the counterparty.
    """
    DomesticCurrencyIssued: Optional[cdm.product.collateral.DomesticCurrencyIssued.DomesticCurrencyIssued] = Field(None, description="Criteria is that collateral must be denominated in the domestic currency of the issuer.")
    """
    Criteria is that collateral must be denominated in the domestic currency of the issuer.
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        item = self
        return rosetta_check_one_of(self, 'AllCriteria', 'AnyCriteria', 'NegativeCriteria', 'CollateralIssuerType', 'AssetType', 'IssuerCountryOfOrigin', 'AssetCountryOfOrigin', 'CurrencyCodeEnum', 'IssuerName', 'IssuerAgencyRating', 'SovereignAgencyRating', 'AssetAgencyRating', 'AssetMaturity', 'SpecificAsset', 'CollateralTaxonomy', 'ListingExchange', 'ListingSector', 'Index', 'CounterpartyOwnIssuePermitted', 'DomesticCurrencyIssued', necessity=True)

import cdm 
import cdm.product.collateral.AllCriteria
import cdm.product.collateral.AnyCriteria
import cdm.product.collateral.NegativeCriteria
import cdm.base.staticdata.asset.common.CollateralIssuerType
import cdm.base.staticdata.asset.common.AssetType
import cdm.product.collateral.IssuerCountryOfOrigin
import cdm.product.collateral.AssetCountryOfOrigin
import cdm.base.staticdata.asset.common.CurrencyCodeEnum
import cdm.product.collateral.IssuerName
import cdm.product.collateral.IssuerAgencyRating
import cdm.product.collateral.SovereignAgencyRating
import cdm.product.collateral.AssetAgencyRating
import cdm.product.collateral.AssetMaturity
import cdm.product.collateral.SpecificAsset
import cdm.base.staticdata.asset.common.CollateralTaxonomy
import cdm.product.collateral.ListingExchange
import cdm.product.collateral.ListingSector
import cdm.observable.asset.Index
import cdm.product.collateral.CounterpartyOwnIssuePermitted
import cdm.product.collateral.DomesticCurrencyIssued
