# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AgencyRatingCriteria']


class AgencyRatingCriteria(BaseDataClass):
    """
    Represents a class to specify a credit notation.
    """
    creditNotation: cdm.observable.asset.CreditNotation.CreditNotation = Field(..., description="Indicates the agency rating criteria specified for the asset or issuer.")
    """
    Indicates the agency rating criteria specified for the asset or issuer.
    """
    mismatchResolution: Optional[cdm.observable.asset.CreditNotationMismatchResolutionEnum.CreditNotationMismatchResolutionEnum] = Field(None, description="Indicator for options to be used if several agency ratings (>1) are specified and its necessary to identify specific charateristics. i.e (lowest or highest).")
    """
    Indicator for options to be used if several agency ratings (>1) are specified and its necessary to identify specific charateristics. i.e (lowest or highest).
    """
    referenceAgency: Optional[cdm.observable.asset.CreditRatingAgencyEnum.CreditRatingAgencyEnum] = Field(None, description="identifies the dominant reference agency if there is a missmatch and several reference agencies exsist.")
    """
    identifies the dominant reference agency if there is a missmatch and several reference agencies exsist.
    """
    boundary: Optional[cdm.observable.asset.CreditNotationBoundaryEnum.CreditNotationBoundaryEnum] = Field(None, description="Indicates the boundary of a credit agency rating i.e minimum or maximum.")
    """
    Indicates the boundary of a credit agency rating i.e minimum or maximum.
    """
    
    @rosetta_condition
    def condition_0_ReferenceAgency(self):
        """
        If the mismatch resolution is ReferenceAgency, ensure that the reference agency is specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "referenceAgency"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "mismatchResolution"), "=", rosetta_resolve_attr(CreditNotationMismatchResolutionEnum, "REFERENCE_AGENCY")), _then_fn0, _else_fn0)

import cdm 
import cdm.observable.asset.CreditNotation
import cdm.observable.asset.CreditNotationMismatchResolutionEnum
import cdm.observable.asset.CreditRatingAgencyEnum
import cdm.observable.asset.CreditNotationBoundaryEnum
from cdm.observable.asset.CreditNotationMismatchResolutionEnum import CreditNotationMismatchResolutionEnum
