# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ContractualDefinition']


class ContractualDefinition(BaseDataClass):
    identifier: Optional[cdm.base.staticdata.identifier.Identifier.Identifier] = Field(None, description="Corresponds to the unique identifier of the Contractual Definition in which the code is published")
    """
    Corresponds to the unique identifier of the Contractual Definition in which the code is published
    """
    contractualDefinitionIdentifier: Optional[cdm.observable.asset.fro.ContractualDefinitionIdentifier.ContractualDefinitionIdentifier] = Field(None, description="Contractual Definition Identifier in which the code is published. Includes Document Type and Document Version")
    """
    Contractual Definition Identifier in which the code is published. Includes Document Type and Document Version
    """
    publicationDate: Optional[datetime.date] = Field(None, description="2021-06-11")
    """
    2021-06-11
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        """
        Choice between document uuid or document type and version
        """
        item = self
        return rosetta_check_one_of(self, 'identifier', 'contractualDefinitionIdentifier', necessity=False)

import cdm 
import cdm.base.staticdata.identifier.Identifier
import cdm.observable.asset.fro.ContractualDefinitionIdentifier
