# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['GeneralNonTransferability']


class GeneralNonTransferability(BaseDataClass):
    generalNonTransferabilityIsApplicable: bool = Field(..., description="")
    localSubstituteProvisionType: Optional[cdm.legaldocumentation.transaction.additionalterms.FxSubstitutionProvisionTypeEnum.FxSubstitutionProvisionTypeEnum] = Field(None, description="")
    maximumDaysOfDisruption: Optional[cdm.observable.asset.ValuationPostponement.ValuationPostponement] = Field(None, description="Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.")
    """
    Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.
    """
    nonDeliverableSubstitute: Optional[cdm.legaldocumentation.transaction.additionalterms.NonDeliverableSubstitute.NonDeliverableSubstitute] = Field(None, description="")
    escrowArrangement: Optional[cdm.legaldocumentation.transaction.additionalterms.EscrowArrangement.EscrowArrangement] = Field(None, description="Refers to the segregation deposit procedure parties may want to commmit into during the time a Disruption Event is effective")
    """
    Refers to the segregation deposit procedure parties may want to commmit into during the time a Disruption Event is effective
    """
    
    @rosetta_condition
    def condition_0_SettlementPostponementExistence(self):
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "maximumDaysOfDisruption"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "localSubstituteProvisionType"), "=", rosetta_resolve_attr(FxSubstitutionProvisionTypeEnum, "LOCAL_CURRENCY_SUBSTITUTE")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_SubstituteTermsChoice(self):
        item = self
        def _then_fn1():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "localSubstituteProvisionType")))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(self, "nonDeliverableSubstitute"))) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "nonDeliverableSubstitute")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "localSubstituteProvisionType")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.transaction.additionalterms.FxSubstitutionProvisionTypeEnum
import cdm.observable.asset.ValuationPostponement
import cdm.legaldocumentation.transaction.additionalterms.NonDeliverableSubstitute
import cdm.legaldocumentation.transaction.additionalterms.EscrowArrangement
from cdm.legaldocumentation.transaction.additionalterms.FxSubstitutionProvisionTypeEnum import FxSubstitutionProvisionTypeEnum
