# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['FxIllegalityOrImpossibilityEnum']

class FxIllegalityOrImpossibilityEnum(Enum):
    """
    The enumerated values to specify whether such terms i.e. Illegality or Impossibility shall be treated either as defined per the documents applicable to the FX transaction.
    """
    TO_BE_TREATED_AS_DISRUPTION_EVENT = "ToBeTreatedAsDisruptionEvent"
    TO_BE_TREATED_AS_ILLEGALITY_OR_IMPOSSIBILITY = "ToBeTreatedAsIllegalityOrImpossibility"
