# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EventCurrency']


class EventCurrency(BaseDataClass):
    """
    Defines the currency referenced as such in any terms related to FX Disruption Events
    """
    eventCurrency: AttributeWithMeta[str] | str = Field(..., description="Defines the currency referenced as such in any terms related to FX Disruption Events")
    """
    Defines the currency referenced as such in any terms related to FX Disruption Events
    """
    eventCurrentAmount: Optional[cdm.base.math.Quantity.Quantity] = Field(None, description="Defines the Event Currency Amount to be exchanged on the Settlement Date.")
    """
    Defines the Event Currency Amount to be exchanged on the Settlement Date.
    """
    eventCurrencyBuyerSeller: List[cdm.base.staticdata.party.BuyerSeller.BuyerSeller] = Field([], description="Unless otherwised specified, the Buyer is the party to which the Event Currency Amount is owed on the Settlement Date and the Seller is the party which owes the Event Currency Amount on the Settlement Date.")
    """
    Unless otherwised specified, the Buyer is the party to which the Event Currency Amount is owed on the Settlement Date and the Seller is the party which owes the Event Currency Amount on the Settlement Date.
    """

import cdm 
import cdm.base.math.Quantity
import cdm.base.staticdata.party.BuyerSeller
