# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['TerminationCurrencySelection']


class TerminationCurrencySelection(BaseDataClass):
    """
    Specifies Termination Currency where a currency is stated at the time the agreement is entered into.
    """
    statedCurrency: Optional[str] = Field(None, description="Specifies a single Termination Currency for the agreement.")
    """
    Specifies a single Termination Currency for the agreement.
    """
    fallbackCurrency: Optional[str] = Field(None, description="Specifies a single fallback Termination Currency should the stated currency not be freely available.")
    """
    Specifies a single fallback Termination Currency should the stated currency not be freely available.
    """
    partyElection: List[cdm.legaldocumentation.master.isda.PartyTerminationCurrencySelection.PartyTerminationCurrencySelection] = Field([], description="Specifies different termination currencies to apply depending on which party or parties are the Defaulting Party Affected Party(ies).")
    """
    Specifies different termination currencies to apply depending on which party or parties are the Defaulting Party Affected Party(ies).
    """
    bothAffected: Optional[str] = Field(None, description="Specifies fallback Termination Currency where both parties are Affected Parties.")
    """
    Specifies fallback Termination Currency where both parties are Affected Parties.
    """

import cdm 
import cdm.legaldocumentation.master.isda.PartyTerminationCurrencySelection
