# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MasterAgreement']

from cdm.legaldocumentation.master.MasterAgreementBase import MasterAgreementBase

class MasterAgreement(MasterAgreementBase):
    """
    The set of elections that define an ISDA Master Agreement.
    """
    automaticEarlyTermination: cdm.legaldocumentation.master.isda.AutomaticEarlyTermination.AutomaticEarlyTermination = Field(..., description="The specification of whether there is an automatic occurrence of an Early Termination Date in respect of Transactions upon the occurrence of certain bankruptcy / insolvency related events.")
    """
    The specification of whether there is an automatic occurrence of an Early Termination Date in respect of Transactions upon the occurrence of certain bankruptcy / insolvency related events.
    """
    terminationCurrency: cdm.legaldocumentation.master.isda.TerminationCurrency.TerminationCurrency = Field(..., description="Specification of the currency in which the termination payment is made (including the process by which such currency is determined).")
    """
    Specification of the currency in which the termination payment is made (including the process by which such currency is determined).
    """
    addressForNotices: cdm.legaldocumentation.common.AddressForNotices.AddressForNotices = Field(..., description="Specification of the address and other details for notices.")
    """
    Specification of the address and other details for notices.
    """
    nonContractualObligations: bool = Field(..., description="Specification of whether the Governing Law clause extends to Non-Contractual Obligations (True) or does not extend to Non-Contractual Obligations (False).")
    """
    Specification of whether the Governing Law clause extends to Non-Contractual Obligations (True) or does not extend to Non-Contractual Obligations (False).
    """
    creditSupportDocument: cdm.legaldocumentation.csa.CreditSupportDocument.CreditSupportDocument = Field(..., description="Identification of party specific Credit Support Documents applicable to the document.")
    """
    Identification of party specific Credit Support Documents applicable to the document.
    """
    creditSupportProvider: cdm.legaldocumentation.csa.CreditSupportProvider.CreditSupportProvider = Field(..., description="Identification of party specific Credit Support Providers applicable to the document.")
    """
    Identification of party specific Credit Support Providers applicable to the document.
    """
    specifiedEntities: List[cdm.legaldocumentation.master.isda.SpecifiedEntities.SpecifiedEntities] = Field([], description="A provision that allows each party to specify its Specified Entities for certain Events of Default and Termination Events.")
    """
    A provision that allows each party to specify its Specified Entities for certain Events of Default and Termination Events.
    """
    @rosetta_condition
    def cardinality_specifiedEntities(self):
        return check_cardinality(self.specifiedEntities, 4, None)
    

import cdm 
import cdm.legaldocumentation.master.isda.AutomaticEarlyTermination
import cdm.legaldocumentation.master.isda.TerminationCurrency
import cdm.legaldocumentation.common.AddressForNotices
import cdm.legaldocumentation.csa.CreditSupportDocument
import cdm.legaldocumentation.csa.CreditSupportProvider
import cdm.legaldocumentation.master.isda.SpecifiedEntities
