# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.legaldocumentation.csa.PostedCreditSupportItem import PostedCreditSupportItem
from cdm.observable.asset.Money import Money

__all__ = ['PostedCreditSupportItemAmount']


@replaceable
def PostedCreditSupportItemAmount(postedItem: PostedCreditSupportItem, baseCurrency: str) -> Money:
    """
    Calculates the Value for the given Posted Credit Support item.
    
    Parameters 
    ----------
    postedItem : PostedCreditSupportItem
    Posted Credit Support Item.
    
    baseCurrency : string
    Base Currency means the currency specified as such in Paragraph 13.
    
    Returns
    -------
    result : Money
    
    """
    _pre_registry = {}
    self = inspect.currentframe()
    
    # conditions
    
    @rosetta_local_condition(_pre_registry)
    def condition_0_CurrencyMatches(self):
        return (all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "cashOrSecurityValue"), "unit"), "currency")) and all_elements(rosetta_resolve_attr(self, "baseCurrency"), "=", rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "disputedCashOrSecurityValue"), "unit"), "currency")))
    # Execute all registered conditions
    execute_local_conditions(_pre_registry, 'Pre-condition')
    
    cashOrSecurityValue = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "cashOrSecurityValue"), "value")
    haircutPercentage = rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "haircutPercentage")
    fxHaircutPercentage = rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "fxHaircutPercentage")
    additionalHaircutPercentage = rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "fxHaircutPercentage")
    postedCreditSupportAmount = (rosetta_resolve_attr(self, "cashOrSecurityValue") * (1.00 - ((rosetta_resolve_attr(self, "haircutPercentage") + rosetta_resolve_attr(self, "fxHaircutPercentage")) + rosetta_resolve_attr(self, "additionalHaircutPercentage"))))
    result = _get_rosetta_object('Money', 'value', (rosetta_resolve_attr(self, "postedCreditSupportAmount") - rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "postedItem"), "disputedCashOrSecurityValue"), "value")))
    result = set_rosetta_attr(rosetta_resolve_attr(self, 'result'), 'unit->currency', rosetta_resolve_attr(self, "baseCurrency"))
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
