# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValuationTimeDayEnum']

class ValuationTimeDayEnum(Enum):
    """
    The day at which the value of the collateral and obligations to transfer or return collateral are to be calculated relative to the Valuation Date.
    """
    AS_SELECTED = "As Selected"
    """
    Should be calculated relative to the previous local business day as selected.
    """
    PREVIOUS_LOCAL_BUSINESS_DAY = "Previous Local Business Day"
    """
    Should be calculated relative to the previous local business day.
    """
    PREVIOUS_LOCAL_BUSINESS_DAY_CITY_OF_AGENT = "Previous Local Business Day (City of Valuation Agent)"
    """
    Should be calculated relative to the previous local business day in the city of the Valuation Agent.
    """
    PREVIOUS_LOCAL_BUSINESS_DAY_MARKET = "Previous Local Business Day (Relevant Market)"
    """
    Should be calculated relative to the previous local business day in the Relevant Market).
    """
    VALUATION_DATE = "Valuation Date"
    """
    Should be calculated on the Valuation Date.
    """
