# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SubstitutedRegimeTerms']


class SubstitutedRegimeTerms(BaseDataClass):
    """
    Specifies the applicability of the Substituted Regime as denoted in the Substituted Regime Table as part of certain legal agreements, such as such as the ISDA 2016 and 2018 CSA for Initial Margin.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The party for which the regime terms are being specified when acting as collateral taker.")
    """
    The party for which the regime terms are being specified when acting as collateral taker.
    """
    isApplicable: bool = Field(..., description="The specification of whether the regime is elected as applicable to the party when acting as collateral taker.")
    """
    The specification of whether the regime is elected as applicable to the party when acting as collateral taker.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
