# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SubstitutedRegime']


class SubstitutedRegime(BaseDataClass):
    """
    A class to specify each party's election with respect to the Substituted Regimes that will be applicable...
    """
    regime: Optional[cdm.legaldocumentation.csa.RegulatoryRegimeEnum.RegulatoryRegimeEnum] = Field(None, description="The applicable regulatory regime, as specified through an enumeration.")
    """
    The applicable regulatory regime, as specified through an enumeration.
    """
    additionalRegime: Optional[str] = Field(None, description="The additional regulatory regime as specified by the parties.")
    """
    The additional regulatory regime as specified by the parties.
    """
    regimeTerms: List[cdm.legaldocumentation.csa.SubstitutedRegimeTerms.SubstitutedRegimeTerms] = Field([], description="Specifies the applicability of the Substituted Regime as denoted in the Substituted Regime Table as part of certain legal agreements, such as the ISDA 2016 and 2018 CSA for Initial Margin.")
    """
    Specifies the applicability of the Substituted Regime as denoted in the Substituted Regime Table as part of certain legal agreements, such as the ISDA 2016 and 2018 CSA for Initial Margin.
    """
    @rosetta_condition
    def cardinality_regimeTerms(self):
        return check_cardinality(self.regimeTerms, 2, None)
    
    
    @rosetta_condition
    def condition_0_SubstitutedRegimeChoice(self):
        """
        The applicable regime should be specified either as an enumeration or as an additional regime specified by the parties.
        """
        item = self
        return rosetta_check_one_of(self, 'regime', 'additionalRegime', necessity=True)

import cdm 
import cdm.legaldocumentation.csa.RegulatoryRegimeEnum
import cdm.legaldocumentation.csa.SubstitutedRegimeTerms
