# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SimmVersion']


class SimmVersion(BaseDataClass):
    """
    A class to specify the ISDA SIMM version that applies to the ISDA 2018 CSA for Initial Margin.
    """
    isSpecified: Optional[bool] = Field(None, description="A boolean attribute to determine whether the SIMM version is specified for the purpose of the legal agreement.")
    """
    A boolean attribute to determine whether the SIMM version is specified for the purpose of the legal agreement.
    """
    partyVersion: Optional[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field(None, description="The party which the specified SIMM version applies to.")
    """
    The party which the specified SIMM version applies to.
    """
    asSpecified: Optional[str] = Field(None, description="The SIMM version exception when specified as a customized approach by the party.")
    """
    The SIMM version exception when specified as a customized approach by the party.
    """
    
    @rosetta_condition
    def condition_0_VersionNotSpecified(self):
        """
        A data rule to enforce that the version attribute should be absent when the SIMM version is stated as not specified for the CSA.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "partyVersion")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isSpecified"), "=", False), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_VersionSpecified(self):
        """
        A data rule to enforce that the version attribute should be specified when the SIMM version is stated as specified for the CSA.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "partyVersion"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isSpecified"), "=", True), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
