# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SimmException']


class SimmException(BaseDataClass):
    """
    A class to specify the SIMM exception to the regulatory regime clause.
    """
    standardisedException: Optional[cdm.legaldocumentation.csa.ExceptionEnum.ExceptionEnum] = Field(None, description="The Standard Initial Margin Model exception when specified by the party according to one of the enumerated values.")
    """
    The Standard Initial Margin Model exception when specified by the party according to one of the enumerated values.
    """
    simmExceptionApplicable: Optional[cdm.legaldocumentation.csa.SimmExceptionApplicableEnum.SimmExceptionApplicableEnum] = Field(None, description="The Standard Initial Margin model exception approach applicable when specified by the party according to one of the enumerated values.")
    """
    The Standard Initial Margin model exception approach applicable when specified by the party according to one of the enumerated values.
    """
    asSpecified: Optional[str] = Field(None, description="The Standard Initial Margin Model exception when specified as a customized approach by the party.")
    """
    The Standard Initial Margin Model exception when specified as a customized approach by the party.
    """

import cdm 
import cdm.legaldocumentation.csa.ExceptionEnum
import cdm.legaldocumentation.csa.SimmExceptionApplicableEnum
