# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['SensitivitiesEnum']

class SensitivitiesEnum(Enum):
    """
    Values to specify the methodology according to which sensitivities to (i) equity indices, funds and ETFs, and (ii) commodity indices are computed.
    """
    ALTERNATIVE = "Alternative"
    """
    The parties agree that in respect of the relevant sensitivities, the delta is allocated back to individual constituents.
    """
    STANDARD = "Standard"
    """
    The relevant sensitivities are addressed by the standard preferred approach where the entire delta is put into the applicable asset class/category.
    """
