# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['SecurityInterestObligationsEnum']

class SecurityInterestObligationsEnum(Enum):
    """
    The enumerated values applicable for Security Interest for Obligations.
    """
    ALL_OBLIGATIONS_OF_PARTY_A = "All Obligations of Party A"
    """
    All Obligations of Party A.
    """
    ALL_OBLIGATIONS_OF_PARTY_B = "All Obligations of Party B"
    """
    All Obligations of Party B.
    """
    NOT_APPLICABLE = "NotApplicable"
    """
    Security Interest for Obligations is not applicable to the Party.
    """
    OTHER = "Other"
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """
