# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityAgreementElections']


class SecurityAgreementElections(BaseDataClass):
    """
    The set of elections which specify a Security Agremeent.
    """
    pledgedAccount: Optional[cdm.base.staticdata.party.Account.Account] = Field(None, description="The pledged account associated with the agreement.")
    """
    The pledged account associated with the agreement.
    """
    enforcementEvent: Optional[cdm.legaldocumentation.csa.EnforcementEvent.EnforcementEvent] = Field(None, description="Enforcement Events specific to the agreement.")
    """
    Enforcement Events specific to the agreement.
    """
    deliveryInLieuRight: Optional[bool] = Field(None, description="Delivery In Lieu rights.")
    """
    Delivery In Lieu rights.
    """
    fullDischarge: Optional[bool] = Field(None, description="Full Discharge condition.")
    """
    Full Discharge condition.
    """
    appropriatedCollateralValuation: Optional[cdm.legaldocumentation.csa.AppropriatedCollateralValuation.AppropriatedCollateralValuation] = Field(None, description="The election for the Valuation of Appropriate Collateral.")
    """
    The election for the Valuation of Appropriate Collateral.
    """
    processAgent: Optional[cdm.legaldocumentation.csa.ProcessAgent.ProcessAgent] = Field(None, description="The Process Agent that might be appointed by the parties to the agreement.")
    """
    The Process Agent that might be appointed by the parties to the agreement.
    """
    jurisdictionRelatedTerms: Optional[cdm.legaldocumentation.csa.JurisdictionRelatedTerms.JurisdictionRelatedTerms] = Field(None, description="The jurisdiction specific terms.")
    """
    The jurisdiction specific terms.
    """
    additionalAmendments: Optional[str] = Field(None, description="Any additional amendments that might be specified by the parties to the agreement.")
    """
    Any additional amendments that might be specified by the parties to the agreement.
    """
    additionalBespokeTerms: Optional[str] = Field(None, description="Any additional terms that might be specified applicable.")
    """
    Any additional terms that might be specified applicable.
    """
    executionTerms: Optional[cdm.legaldocumentation.csa.ExecutionTerms.ExecutionTerms] = Field(None, description="The location and language of execution to determine duty to be paid.")
    """
    The location and language of execution to determine duty to be paid.
    """

import cdm 
import cdm.base.staticdata.party.Account
import cdm.legaldocumentation.csa.EnforcementEvent
import cdm.legaldocumentation.csa.AppropriatedCollateralValuation
import cdm.legaldocumentation.csa.ProcessAgent
import cdm.legaldocumentation.csa.JurisdictionRelatedTerms
import cdm.legaldocumentation.csa.ExecutionTerms
