# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['RightsEvents']


class RightsEvents(BaseDataClass):
    """
    A class to specify the rights of Security Taker and/or Security Provider when an Early Termination or Access Condition event has occurred.
    """
    securityTakerRightsEvent: cdm.legaldocumentation.csa.SecuredPartyRightsEvent.SecuredPartyRightsEvent = Field(..., description="The bespoke provisions that might be specified by the parties to the agreement applicable to a Security Taker Rights Event.")
    """
    The bespoke provisions that might be specified by the parties to the agreement applicable to a Security Taker Rights Event.
    """
    controlAgreementNecEvent: Optional[cdm.legaldocumentation.csa.ControlAgreementNecEvent.ControlAgreementNecEvent] = Field(None, description="The bespoke provisions that might be specified by the parties to the agreement applicable to a Notice of Exclusive Control Event.")
    """
    The bespoke provisions that might be specified by the parties to the agreement applicable to a Notice of Exclusive Control Event.
    """
    securityProviderRightsEvent: cdm.legaldocumentation.csa.SecurityProviderRightsEvent.SecurityProviderRightsEvent = Field(..., description="The bespoke provisions that might be specified by the parties to the agreement applicable to a Security Provider Rights Event.")
    """
    The bespoke provisions that might be specified by the parties to the agreement applicable to a Security Provider Rights Event.
    """
    deliveryInLieuRight: Optional[bool] = Field(None, description="The specification of whether Delivery In Lieu language is applicable to the agreement (true) or not (false).")
    """
    The specification of whether Delivery In Lieu language is applicable to the agreement (true) or not (false).
    """
    additionalRightsEvent: Optional[cdm.legaldocumentation.csa.AdditionalRightsEvent.AdditionalRightsEvent] = Field(None, description="The Additional Rights Event election.")
    """
    The Additional Rights Event election.
    """

import cdm 
import cdm.legaldocumentation.csa.SecuredPartyRightsEvent
import cdm.legaldocumentation.csa.ControlAgreementNecEvent
import cdm.legaldocumentation.csa.SecurityProviderRightsEvent
import cdm.legaldocumentation.csa.AdditionalRightsEvent
