# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['RecalculationOfValueElection']


class RecalculationOfValueElection(BaseDataClass):
    """
    A class to specify Recalculation of Value terms that will be applicable.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    recalculationOfValueElection: cdm.legaldocumentation.csa.RecalculationOfValueElectionEnum.RecalculationOfValueElectionEnum = Field(..., description="The procedure for Recalculation of Value.")
    """
    The procedure for Recalculation of Value.
    """
    recalculationOfValueTerms: Optional[str] = Field(None, description="Additional Recalculation of Value terms when specified.")
    """
    Additional Recalculation of Value terms when specified.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.RecalculationOfValueElectionEnum
