# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PostingObligationsElection']


class PostingObligationsElection(BaseDataClass):
    """
    A class to specify the collateral posting obligations for the security provider party(ies).
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    asPermitted: bool = Field(..., description="If set to True, the Control Agreement is a Credit Support Document with respect to the party(ies).")
    """
    If set to True, the Control Agreement is a Credit Support Document with respect to the party(ies).
    """
    eligibleCollateral: List[cdm.product.collateral.EligibleCollateralCriteria.EligibleCollateralCriteria] = Field([], description="The eligible collateral as specified in relation to the pledgor/chargor/obligor(s) posting obligation.")
    """
    The eligible collateral as specified in relation to the pledgor/chargor/obligor(s) posting obligation.
    """
    excludedCollateral: Optional[str] = Field(None, description="The excluded collateral as specified in relation to the pledgor/chargor/obligor(s) posting obligation.")
    """
    The excluded collateral as specified in relation to the pledgor/chargor/obligor(s) posting obligation.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_AsPermitted(self):
        """
        A data rule to enforce that the eligible collateral should be specified when the Control Agreement is a Credit Support Document with respect to the party(ies).
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "eligibleCollateral")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "asPermitted"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_EligibleCollateral(self):
        """
        A data rule to enforce that the eligible collateral shouldn't be specified when the Control Agreement isn't deemed a Credit Support Document with respect to the party(ies).
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "eligibleCollateral"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "asPermitted"), "=", False), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_ConsistentParty(self):
        """
        A data rule to ensure that the elective party is only set on the agreement and not in the eligible collateral criteria.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "eligibleCollateral"), "appliesTo")), "=", 0)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "eligibleCollateral")), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.product.collateral.EligibleCollateralCriteria
