# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OtherEligibleAndPostedSupport']


class OtherEligibleAndPostedSupport(BaseDataClass):
    """
    A class to specify the Other Eligible Support elections associated Initial and Variation margin agreements.
    """
    applicableValue: bool = Field(..., description="The definition of 'Value' with respect to Other Eligible Support (IM) and Other Posted Support (IM).")
    """
    The definition of 'Value' with respect to Other Eligible Support (IM) and Other Posted Support (IM).
    """
    applicableTransfer: Optional[bool] = Field(None, description="The definition of 'Transfer' with respect to Other Eligible Support (IM) and Other Posted Support (IM).")
    """
    The definition of 'Transfer' with respect to Other Eligible Support (IM) and Other Posted Support (IM).
    """

import cdm 
