# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['NotificationTimeElection']


class NotificationTimeElection(BaseDataClass):
    """
    A class to specify the notification time election by the respective parties to the agreement.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    notificationTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The Notification Time as a time that is qualified as a standard business center.")
    """
    The Notification Time as a time that is qualified as a standard business center.
    """
    customNotification: Optional[str] = Field(None, description="The Notification Time as a bespoke election.")
    """
    The Notification Time as a bespoke election.
    """
    localBusinessDay: Optional[bool] = Field(None, description="Whether the Notification Time is precluded on the day being a local business day.")
    """
    Whether the Notification Time is precluded on the day being a local business day.
    """
    
    @rosetta_condition
    def condition_0_NotificationTimeElectionChoice(self):
        """
        The Notification Time is specified either as a time that is qualified by a standard business center or as a custom election.
        """
        item = self
        return rosetta_check_one_of(self, 'notificationTime', 'customNotification', necessity=True)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.base.datetime.BusinessCenterTime
