# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MinimumTransferAmountAmendment']


class MinimumTransferAmountAmendment(BaseDataClass):
    """
     A class to specify whether Amendment to Minimum Transfer Amount language is applicable or not.
    """
    isApplicable: bool = Field(..., description="The definition of Minimum Transfer Amount in any Other Regulatory CSA will be amended when applicable.")
    """
    The definition of Minimum Transfer Amount in any Other Regulatory CSA will be amended when applicable.
    """
    effectiveDate: Optional[cdm.legaldocumentation.csa.AmendmentEffectiveDate.AmendmentEffectiveDate] = Field(None, description="The effective date of the Amendment to Termination Currency.")
    """
    The effective date of the Amendment to Termination Currency.
    """
    partyElections: List[cdm.legaldocumentation.csa.ElectiveAmountElection.ElectiveAmountElection] = Field([], description="The party elective amounts.")
    """
    The party elective amounts.
    """
    
    @rosetta_condition
    def condition_0_AmendmentNotApplicable(self):
        """
        A data rule to enforce that the Effective Date and Party Elections should be absent when the Minimum Transfer Amount Amendment is stated as not specified for the agreement.
        """
        item = self
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(self, "effectiveDate"))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "partyElections"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.AmendmentEffectiveDate
import cdm.legaldocumentation.csa.ElectiveAmountElection
