# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['MTAZeroEventEnum']

class MTAZeroEventEnum(Enum):
    """
    The enumerated values for defining the relevant trigger(s) for the Minimum Transfer Amount (MTA) to fall to zero.
    """
    ADDITIONAL_TERMINATION_EVENT = "AdditionalTerminationEvent"
    """
    An Additional Termination Event (ATE).
    """
    EVENT_OF_DEFAULT = "EventOfDefault"
    """
    An Event of Default.
    """
    OTHER = "Other"
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """
    POTENTIAL_EVENT_OF_DEFAULT = "PotentialEventOfDefault"
    """
    A Potential Event of Default.
    """
    TERMINATION_EVENT = "TerminationEvent"
    """
    A Termination Event.
    """
    TERMINATION_EVENT_ALL_AFFECTED_TRANSACTIONS = "A Termination Event in respect of which all Transactions are Affected Transactions"
    """
    A Termination Event in respect of which all Transactions are Affected Transactions.
    """
