# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MTAType']


class MTAType(BaseDataClass):
    """
    Details whether the Minimum Transfer Amount is rating based, a fixed amount, or infinity.
    """
    fixedAmount: Optional[cdm.legaldocumentation.csa.MTAFixedAmount.MTAFixedAmount] = Field(None, description="Defines that the Minimum Transfer Amount (MTA) is a Fixed Amount.")
    """
    Defines that the Minimum Transfer Amount (MTA) is a Fixed Amount.
    """
    ratingsBased: Optional[cdm.legaldocumentation.csa.MTARatingsBased.MTARatingsBased] = Field(None, description="Defines that the Minimum Transfer Amount (MTA) is based on a Ratings condition(s).")
    """
    Defines that the Minimum Transfer Amount (MTA) is based on a Ratings condition(s).
    """
    other: Optional[str] = Field(None, description="Utilised where the clause data structure is not able to capture a material aspect of the clause.")
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """

import cdm 
import cdm.legaldocumentation.csa.MTAFixedAmount
import cdm.legaldocumentation.csa.MTARatingsBased
