# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyValuationTime']


class LegacyValuationTime(BaseDataClass):
    """
    The time by which the value of the collateral and obligations to transfer or return collateral are to be calculated relative to the Valuation Date.
    """
    day: Optional[cdm.legaldocumentation.csa.ValuationTimeDayEnum.ValuationTimeDayEnum] = Field(None, description="The day in respect of which the Valuation Time is being specified. If not specified, addional language must be used to define the methodology.")
    """
    The day in respect of which the Valuation Time is being specified. If not specified, addional language must be used to define the methodology.
    """
    location: List[cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] = Field([], description="The location relevant to the timezone for the Valuation Time.")
    """
    The location relevant to the timezone for the Valuation Time.
    """
    time: Optional[cdm.legaldocumentation.csa.ValuationTimeEnum.ValuationTimeEnum] = Field(None, description="The type of time specified for the Valuation Time.")
    """
    The type of time specified for the Valuation Time.
    """
    hourminutetime: Optional[datetime.time] = Field(None, description="A time specified in a 24-hour notation, e.g. 3pm would be represented as 15:00.")
    """
    A time specified in a 24-hour notation, e.g. 3pm would be represented as 15:00.
    """
    timezone: Optional[cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] = Field(None, description="Any relevant time zone where specified.")
    """
    Any relevant time zone where specified.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_AdditionalLanguage(self):
        """
        If no Day valuation methodology is defined, additional language must be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "day"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_DayAndTime(self):
        """
        Day and Time must be used together and neither can be used alone.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "time"))
        
        def _else_fn0():
            return ((((not rosetta_attr_exists(rosetta_resolve_attr(self, "time"))) and (not rosetta_attr_exists(rosetta_resolve_attr(item, "location")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "hourminutetime")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "timezone"))))
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "day")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.ValuationTimeDayEnum
import cdm.base.datetime.BusinessCenterEnum
import cdm.legaldocumentation.csa.ValuationTimeEnum
