# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['InterestAdjustmentPeriodicityEnum']

class InterestAdjustmentPeriodicityEnum(Enum):
    """
    Values to specify the interest adjustment periodicity election through standard language.
    """
    EACH_DAY = "EachDay"
    """
    The interest adjustment takes place each day.
    """
    LAST_LOCAL_BUSINESS_DAY_OF_MONTH = "LastLocalBusinessDayOfMonth"
    """
    The interest adjustment takes place on the last local business day of each calendar month.
    """
