# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FrenchLawAddendum']


class FrenchLawAddendum(BaseDataClass):
    """
    A class to specify party specific elections when a Collateral Transfer Agreement is governed by French Law.
    """
    isApplicable: bool = Field(..., description="The qualification of whether the French Law Addendum is deemed applicable by the parties (True) or not (False).")
    """
    The qualification of whether the French Law Addendum is deemed applicable by the parties (True) or not (False).
    """
    partyElection: List[cdm.legaldocumentation.csa.FrenchLawAddendumElection.FrenchLawAddendumElection] = Field([], description="The parties French Law Addendum Elections.")
    """
    The parties French Law Addendum Elections.
    """
    
    @rosetta_condition
    def condition_0_Applicable(self):
        """
        A data rule to enforce that the French Law Addendum party elections must be specified when applicable.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_count(rosetta_resolve_attr(self, "partyElection")), "=", 2)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", True), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.FrenchLawAddendumElection
