# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExecutionLocation']


class ExecutionLocation(BaseDataClass):
    """
    A class to specify execution location terms of a Security Agreement.
    """
    executionLocation: cdm.legaldocumentation.common.ExecutionLocationEnum.ExecutionLocationEnum = Field(..., description="The execution location of the agreement.")
    """
    The execution location of the agreement.
    """
    otherLanguage: Optional[str] = Field(None, description="Bespoke execution location language to be included when specified.")
    """
    Bespoke execution location language to be included when specified.
    """
    dutyPayer: Optional[str] = Field(None, description="The payer of documentary duty.")
    """
    The payer of documentary duty.
    """
    dutyPayerLanguage: Optional[str] = Field(None, description="Bespoke terms specific to the payment of documentary duty.")
    """
    Bespoke terms specific to the payment of documentary duty.
    """
    dutyPaymentDate: Optional[datetime.date] = Field(None, description="The date that documentary duty will be paid.")
    """
    The date that documentary duty will be paid.
    """
    dutyPaymentLanguage: Optional[str] = Field(None, description="Bespoke terms specific to the date that documentary duty will be paid.")
    """
    Bespoke terms specific to the date that documentary duty will be paid.
    """
    
    @rosetta_condition
    def condition_0_DutyPayerLanguage(self):
        """
        A data rule to enforce that Duty Payer Language should only be specified when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "dutyPayerLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "dutyPayer"), "=", "Specify"), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_DutyPaymentLanguage(self):
        """
        A data rule to enforce that Duty Payment Language should be absent when a Duty Payment date is provided.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "dutyPaymentLanguage")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "dutyPaymentDate")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_OtherLanguage(self):
        """
        A data rule to enforce that bespoke execution language must be included if non-standard execution language is specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "otherLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "executionLocation"), "=", rosetta_resolve_attr(ExecutionLocationEnum, "OTHER_LOCATION")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.common.ExecutionLocationEnum
from cdm.legaldocumentation.common.ExecutionLocationEnum import ExecutionLocationEnum
