# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EligibilityToHoldCollateral']


class EligibilityToHoldCollateral(BaseDataClass):
    """
    A class to specify the conditions under which a party and its custodian(s) are entitled to hold collateral.
    """
    partyTerms: List[cdm.legaldocumentation.csa.HoldingPostedCollateralEnum.HoldingPostedCollateralEnum] = Field([], description="The condition(s) required by a party from the other party to hold its posted collateral.")
    """
    The condition(s) required by a party from the other party to hold its posted collateral.
    """
    @rosetta_condition
    def cardinality_partyTerms(self):
        return check_cardinality(self.partyTerms, 1, None)
    
    custodianTerms: Optional[cdm.legaldocumentation.csa.CustodianTerms.CustodianTerms] = Field(None, description="The restrictions that might be required by a party from the other party's custodian agent to hold its posted collateral.")
    """
    The restrictions that might be required by a party from the other party's custodian agent to hold its posted collateral.
    """
    eligibleCountry: List[AttributeWithMeta[str] | str] = Field([], description="The restrictions that might be required by a party from the other party in terms of country(ies) where collateral can be held.")
    """
    The restrictions that might be required by a party from the other party in terms of country(ies) where collateral can be held.
    """

import cdm 
import cdm.legaldocumentation.csa.HoldingPostedCollateralEnum
import cdm.legaldocumentation.csa.CustodianTerms
