# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CustodianRiskElection']


class CustodianRiskElection(BaseDataClass):
    """
    A class to specify the Custodian Risk.
    """
    party: Optional[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field(None, description="The elective party.")
    """
    The elective party.
    """
    isSpecified: bool = Field(..., description="The qualification as to whether the risk is deemed as Specified.")
    """
    The qualification as to whether the risk is deemed as Specified.
    """
    qualification: Optional[str] = Field(None, description="The Custodian Risk or Collateral Manager Risk qualification.")
    """
    The Custodian Risk or Collateral Manager Risk qualification.
    """
    
    @rosetta_condition
    def condition_0_Specified(self):
        """
        The Custodian Risk (English Law and New York Law ISDA CSA) or Collateral Manager Risk (Japanese Law ISDA CSA) should only be qualified if that risk is deemed 'specified'.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "qualification")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isSpecified"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
