# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CustodianEventEndDate']


class CustodianEventEndDate(BaseDataClass):
    """
    A class to specify the Custodian Event.
    """
    daysAfterCustodianEvent: cdm.base.datetime.CustomisableOffset.CustomisableOffset = Field(..., description="Election to specify the number of days after the occurrence of the Custodian Event/Collateral Management Event for the purpose of qualifying the CE/CME End Date.")
    """
    Election to specify the number of days after the occurrence of the Custodian Event/Collateral Management Event for the purpose of qualifying the CE/CME End Date.
    """
    releaseDate: cdm.base.datetime.CustomisableOffset.CustomisableOffset = Field(..., description="Election to specify the number of days prior to the termination of the Control Agreement /Collateral Management Event for the purpose of qualifying the CE/CME End Date, in the case where advance notice is given.")
    """
    Election to specify the number of days prior to the termination of the Control Agreement /Collateral Management Event for the purpose of qualifying the CE/CME End Date, in the case where advance notice is given.
    """
    safekeepingPeriodExpiry: Optional[cdm.base.datetime.CustomisableOffset.CustomisableOffset] = Field(None, description="The parties' election to specify the number of days prior to the end of the safekeeping period (Clearstream CTA) purpose of qualifying the CE/CME End Date, in the case where advance notice is given.")
    """
    The parties' election to specify the number of days prior to the end of the safekeeping period (Clearstream CTA) purpose of qualifying the CE/CME End Date, in the case where advance notice is given.
    """
    dateOfTimelyStatement: cdm.base.datetime.CustomisableOffset.CustomisableOffset = Field(..., description="The parties' election to specify the number of days one party has effectively provided the Timely Statement to the other party.")
    """
    The parties' election to specify the number of days one party has effectively provided the Timely Statement to the other party.
    """

import cdm 
import cdm.base.datetime.CustomisableOffset
