# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportObligations']


class CreditSupportObligations(BaseDataClass):
    """
    A class to specify the Credit Support Obligations applicable to the Initial Margin Credit Support Annex.
    """
    deliveryAmount: Optional[str] = Field(None, description="Delivery Amount (VM) has the meaning specified in Paragraph 3(a), unless otherwise specified here.")
    """
    Delivery Amount (VM) has the meaning specified in Paragraph 3(a), unless otherwise specified here.
    """
    returnAmount: Optional[str] = Field(None, description="Return Amount (VM) has the meaning specified in Paragraph 3(a), unless otherwise specified here.")
    """
    Return Amount (VM) has the meaning specified in Paragraph 3(a), unless otherwise specified here.
    """
    marginApproach: Optional[cdm.legaldocumentation.csa.MarginApproach.MarginApproach] = Field(None, description="The selection of Margin Approach applicable to the agreement.")
    """
    The selection of Margin Approach applicable to the agreement.
    """
    otherEligibleSupport: Optional[str] = Field(None, description="The Other Eligible Support election. If not specified, this election is deemed as not applicable.")
    """
    The Other Eligible Support election. If not specified, this election is deemed as not applicable.
    """
    threshold: cdm.legaldocumentation.csa.Threshold.Threshold = Field(..., description="The amount of net exposure that a party is willing to bear in relation to the other party before it requires asking for collateral.")
    """
    The amount of net exposure that a party is willing to bear in relation to the other party before it requires asking for collateral.
    """
    minimumTransferAmount: cdm.legaldocumentation.csa.MinimumTransferAmount.MinimumTransferAmount = Field(..., description="The net amount of exposure reached before collateral has to be posted or returned.")
    """
    The net amount of exposure reached before collateral has to be posted or returned.
    """
    rounding: Optional[cdm.legaldocumentation.csa.CollateralRounding.CollateralRounding] = Field(None, description="The rounding methodology applicable to the Delivery Amount and the Return Amount in terms of nearest integral multiple of Base Currency units.")
    """
    The rounding methodology applicable to the Delivery Amount and the Return Amount in terms of nearest integral multiple of Base Currency units.
    """
    bespokeTransferTiming: Optional[cdm.legaldocumentation.csa.BespokeTransferTiming.BespokeTransferTiming] = Field(None, description="The time by which the transfer of collateral must take place when different from the Regular Settlement Day as a result of parties' election.")
    """
    The time by which the transfer of collateral must take place when different from the Regular Settlement Day as a result of parties' election.
    """
    creditSupportObligationsVariationMargin: Optional[cdm.legaldocumentation.csa.CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMargin] = Field(None, description="The specification of Credit Support Obligations applicable to Variation Margin agreements.")
    """
    The specification of Credit Support Obligations applicable to Variation Margin agreements.
    """
    legacyThreshold: List[cdm.legaldocumentation.csa.CSAThreshold.CSAThreshold] = Field([], description="")
    legacyMinimumTransferAmount: List[cdm.legaldocumentation.csa.CSAMinimumTransferAmount.CSAMinimumTransferAmount] = Field([], description="")
    legacyDeliveryAmount: cdm.legaldocumentation.csa.LegacyDeliveryAmount.LegacyDeliveryAmount = Field(..., description="In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be transferred to it as a Delivery Amount.")
    """
    In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be transferred to it as a Delivery Amount.
    """
    legacyReturnAmount: cdm.legaldocumentation.csa.LegacyReturnAmount.LegacyReturnAmount = Field(..., description="In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be recalled to it as a Return Amount.")
    """
    In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be recalled to it as a Return Amount.
    """
    creditSupportAmount: cdm.legaldocumentation.csa.CreditSupportAmount.CreditSupportAmount = Field(..., description="The total amount one counterparty must deliver to the other at any time: the combination of the Exposure to that party and the net Independent Amounts it must post, minus any agreed Threshold.")
    """
    The total amount one counterparty must deliver to the other at any time: the combination of the Exposure to that party and the net Independent Amounts it must post, minus any agreed Threshold.
    """
    collateralTransferTiming: Optional[cdm.legaldocumentation.csa.CollateralTransferTiming.CollateralTransferTiming] = Field(None, description="Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.")
    """
    Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.
    """

import cdm 
import cdm.legaldocumentation.csa.MarginApproach
import cdm.legaldocumentation.csa.Threshold
import cdm.legaldocumentation.csa.MinimumTransferAmount
import cdm.legaldocumentation.csa.CollateralRounding
import cdm.legaldocumentation.csa.BespokeTransferTiming
import cdm.legaldocumentation.csa.CreditSupportObligationsVariationMargin
import cdm.legaldocumentation.csa.CSAThreshold
import cdm.legaldocumentation.csa.CSAMinimumTransferAmount
import cdm.legaldocumentation.csa.LegacyDeliveryAmount
import cdm.legaldocumentation.csa.LegacyReturnAmount
import cdm.legaldocumentation.csa.CreditSupportAmount
import cdm.legaldocumentation.csa.CollateralTransferTiming
