# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ConditionsPrecedent']


class ConditionsPrecedent(BaseDataClass):
    """
    A class to specify the two set of elections that may overwrite the default Condition Precedent provision.
    """
    conditionsPrecedentElection: Optional[cdm.legaldocumentation.csa.ExceptionEnum.ExceptionEnum] = Field(None, description="The election to specify whether the standard Conditions Precedent apply.")
    """
    The election to specify whether the standard Conditions Precedent apply.
    """
    customProvision: Optional[str] = Field(None, description="The custom provisions that might be specified by the parties to the agreement for the purpose of overwriting the default Condition Precedent provision specified in the CSA.")
    """
    The custom provisions that might be specified by the parties to the agreement for the purpose of overwriting the default Condition Precedent provision specified in the CSA.
    """
    accessConditions: cdm.legaldocumentation.csa.AccessConditions.AccessConditions = Field(..., description="The parties' election with respect to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).")
    """
    The parties' election with respect to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).
    """
    
    @rosetta_condition
    def condition_0_CustomProvision(self):
        """
        When a Custom Provision is specified then the Conditions Precedent Election should be absent.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "conditionsPrecedentElection"), "=", rosetta_resolve_attr(ExceptionEnum, "OTHER"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "customProvision")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.ExceptionEnum
import cdm.legaldocumentation.csa.AccessConditions
from cdm.legaldocumentation.csa.ExceptionEnum import ExceptionEnum
