# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralTransferAgreementElections']


class CollateralTransferAgreementElections(BaseDataClass):
    """
    The set of elections which specify a Collateral Transfer Agreement.
    """
    regime: cdm.legaldocumentation.csa.Regime.Regime = Field(..., description="The Regime Table provision , which determines the regulatory regime(s) applicable to each of the parties to the agreement.")
    """
    The Regime Table provision , which determines the regulatory regime(s) applicable to each of the parties to the agreement.
    """
    oneWayProvisions: cdm.legaldocumentation.csa.OneWayProvisions.OneWayProvisions = Field(..., description="The determination of whether the One Way Provisions are applicable (true) or not applicable (false).")
    """
    The determination of whether the One Way Provisions are applicable (true) or not applicable (false).
    """
    generalSimmElections: cdm.legaldocumentation.csa.GeneralSimmElections.GeneralSimmElections = Field(..., description="The specification of the ISDA SIMM Method for all Covered Transactions with respect to all Regimes.")
    """
    The specification of the ISDA SIMM Method for all Covered Transactions with respect to all Regimes.
    """
    identifiedCrossCurrencySwap: Optional[bool] = Field(None, description="The qualification of whether cross-currency swaps need to be identified in the Confirmation so that the obligations to exchange principal be disregarded for the purpose of determining the Delivery Amount or Return Amount.")
    """
    The qualification of whether cross-currency swaps need to be identified in the Confirmation so that the obligations to exchange principal be disregarded for the purpose of determining the Delivery Amount or Return Amount.
    """
    sensitivityMethodologies: cdm.legaldocumentation.csa.SensitivityMethodologies.SensitivityMethodologies = Field(..., description="The specification of methodologies to compute sensitivities specific to the agreement.")
    """
    The specification of methodologies to compute sensitivities specific to the agreement.
    """
    fxHaircutCurrency: Optional[cdm.legaldocumentation.csa.FxHaircutCurrency.FxHaircutCurrency] = Field(None, description="The reference currency for the purpose of specifying the FX Haircut relating to a posting obligation, as being either the Termination Currency or an FX Designated Currency.")
    """
    The reference currency for the purpose of specifying the FX Haircut relating to a posting obligation, as being either the Termination Currency or an FX Designated Currency.
    """
    postingObligations: cdm.legaldocumentation.csa.PostingObligations.PostingObligations = Field(..., description="The security providers posting obligations.")
    """
    The security providers posting obligations.
    """
    substitutedRegime: List[cdm.legaldocumentation.csa.SubstitutedRegime.SubstitutedRegime] = Field([], description="The specification of Additional regimes for purposes of determining whether a Regulatory Event has occurred.")
    """
    The specification of Additional regimes for purposes of determining whether a Regulatory Event has occurred.
    """
    @rosetta_condition
    def cardinality_substitutedRegime(self):
        return check_cardinality(self.substitutedRegime, 1, None)
    
    baseAndEligibleCurrency: cdm.legaldocumentation.csa.BaseAndEligibleCurrency.BaseAndEligibleCurrency = Field(..., description="The base and eligible currency(ies) for the document as specified by the parties to the agreement.")
    """
    The base and eligible currency(ies) for the document as specified by the parties to the agreement.
    """
    creditSupportObligations: cdm.legaldocumentation.csa.CreditSupportObligations.CreditSupportObligations = Field(..., description="The Credit Support Obligations applicable to the agreement.")
    """
    The Credit Support Obligations applicable to the agreement.
    """
    calculationAndTiming: cdm.legaldocumentation.csa.CalculationAndTiming.CalculationAndTiming = Field(..., description="The set of elections for determining Valuation and Timing terms specific to the agreement.")
    """
    The set of elections for determining Valuation and Timing terms specific to the agreement.
    """
    conditionsPrecedent: cdm.legaldocumentation.csa.ConditionsPrecedent.ConditionsPrecedent = Field(..., description="The set of elections that may overwrite the default Condition Precedent provision, and the set of provisions that are deemed Access Condition.")
    """
    The set of elections that may overwrite the default Condition Precedent provision, and the set of provisions that are deemed Access Condition.
    """
    substitution: Optional[cdm.legaldocumentation.csa.Substitution.Substitution] = Field(None, description="The conditions under which the Security Provider can substitute posted collateral.")
    """
    The conditions under which the Security Provider can substitute posted collateral.
    """
    disputeResolution: cdm.legaldocumentation.csa.DisputeResolution.DisputeResolution = Field(..., description="The election terms under which a party disputes (i) the Calculation Agents calculation of a Delivery Amount or a Return Amount, or (ii) the Value of any Transfer of Eligible Credit Support or Posted Credit Support.")
    """
    The election terms under which a party disputes (i) the Calculation Agents calculation of a Delivery Amount or a Return Amount, or (ii) the Value of any Transfer of Eligible Credit Support or Posted Credit Support.
    """
    rightsEvents: Optional[cdm.legaldocumentation.csa.RightsEvents.RightsEvents] = Field(None, description="The bespoke provisions that might be specified by the parties to the agreement to specify the rights of Security Taker and/or Security Provider when an Early Termination or Access Condition event has occurred.")
    """
    The bespoke provisions that might be specified by the parties to the agreement to specify the rights of Security Taker and/or Security Provider when an Early Termination or Access Condition event has occurred.
    """
    custodyArrangements: cdm.legaldocumentation.csa.CustodyArrangements.CustodyArrangements = Field(..., description="The Custodian and Segregated Account details in respect of each party to the agreement.")
    """
    The Custodian and Segregated Account details in respect of each party to the agreement.
    """
    additionalRepresentations: cdm.legaldocumentation.csa.AdditionalRepresentations.AdditionalRepresentations = Field(..., description="The specification Additional Representations that may be applicable to the agreement.")
    """
    The specification Additional Representations that may be applicable to the agreement.
    """
    demandsAndNotices: Optional[cdm.product.collateral.ContactElection.ContactElection] = Field(None, description="The optional specification of address where the demands, specifications and notices will be communicated to for each of the parties to the agreement.")
    """
    The optional specification of address where the demands, specifications and notices will be communicated to for each of the parties to the agreement.
    """
    addressesForTransfer: Optional[cdm.product.collateral.ContactElection.ContactElection] = Field(None, description="The optional specification of address for transfer as specified by the respective parties to the agreement.")
    """
    The optional specification of address for transfer as specified by the respective parties to the agreement.
    """
    otherCsa: Optional[str] = Field(None, description="The bespoke definition of Other CSA as specified by the parties to the agreement.")
    """
    The bespoke definition of Other CSA as specified by the parties to the agreement.
    """
    terminationCurrencyAmendment: cdm.legaldocumentation.csa.TerminationCurrencyAmendment.TerminationCurrencyAmendment = Field(..., description="The bespoke provision that might be specified by the parties to the agreement applicable to Termination Currency. Unless specified the definition of Termination Currency has the meaning specified in the Schedule to the ISDA Master Agreement.")
    """
    The bespoke provision that might be specified by the parties to the agreement applicable to Termination Currency.  Unless specified the definition of Termination Currency has the meaning specified in the Schedule to the ISDA Master Agreement.
    """
    minimumTransferAmountAmendment: Optional[cdm.legaldocumentation.csa.MinimumTransferAmountAmendment.MinimumTransferAmountAmendment] = Field(None, description="The bespoke provision that might be specified by the parties to the agreement applicable to Minimum Transfer Amount. Unless specified the definition of Minimum Transfer Amount in any Other Regulatory CSA has the meaning specified in such Other Regulatory CSA.")
    """
    The bespoke provision that might be specified by the parties to the agreement applicable to Minimum Transfer Amount.  Unless specified the definition of Minimum Transfer Amount in any Other Regulatory CSA has the meaning specified in such Other Regulatory CSA.
    """
    interpretationTerms: Optional[str] = Field(None, description="The bespoke provision that might be specified by the parties to the agreement applicable to Interpretations.")
    """
    The bespoke provision that might be specified by the parties to the agreement applicable to Interpretations.
    """
    processAgent: Optional[cdm.legaldocumentation.csa.ProcessAgent.ProcessAgent] = Field(None, description="The Process Agent that might be appointed by the parties to the agreement.")
    """
    The Process Agent that might be appointed by the parties to the agreement.
    """
    jurisdictionRelatedTerms: Optional[cdm.legaldocumentation.csa.JurisdictionRelatedTerms.JurisdictionRelatedTerms] = Field(None, description="The jurisdiction specific terms relevant to the agreement.")
    """
    The jurisdiction specific terms relevant to the agreement.
    """
    additionalAmendments: Optional[str] = Field(None, description="Any additional amendments that might be specified by the parties to the agreement.")
    """
    Any additional amendments that might be specified by the parties to the agreement.
    """
    additionalBespokeTerms: Optional[str] = Field(None, description="Any additional terms that might be specified applicable.")
    """
    Any additional terms that might be specified applicable.
    """
    pledgeeRepresentativeRider: Optional[cdm.legaldocumentation.csa.PledgeeRepresentativeRider.PledgeeRepresentativeRider] = Field(None, description="The terms of the Rider for the ISDA Euroclear 2019 Collateral Transfer Agreement with respect to the use of a Pledgee Representative attached to this Agreement.")
    """
    The terms of the Rider for the ISDA Euroclear 2019 Collateral Transfer Agreement with respect to the use of a Pledgee Representative attached to this Agreement.
    """
    finalReturns: cdm.legaldocumentation.csa.FinalReturns.FinalReturns = Field(..., description="A clause providing that final return collateral is to be provided without consideration of any Minimum Transfer Amount and collateral haircut.")
    """
    A clause providing that final return collateral is to be provided without consideration of any Minimum Transfer Amount and collateral haircut.
    """

import cdm 
import cdm.legaldocumentation.csa.Regime
import cdm.legaldocumentation.csa.OneWayProvisions
import cdm.legaldocumentation.csa.GeneralSimmElections
import cdm.legaldocumentation.csa.SensitivityMethodologies
import cdm.legaldocumentation.csa.FxHaircutCurrency
import cdm.legaldocumentation.csa.PostingObligations
import cdm.legaldocumentation.csa.SubstitutedRegime
import cdm.legaldocumentation.csa.BaseAndEligibleCurrency
import cdm.legaldocumentation.csa.CreditSupportObligations
import cdm.legaldocumentation.csa.CalculationAndTiming
import cdm.legaldocumentation.csa.ConditionsPrecedent
import cdm.legaldocumentation.csa.Substitution
import cdm.legaldocumentation.csa.DisputeResolution
import cdm.legaldocumentation.csa.RightsEvents
import cdm.legaldocumentation.csa.CustodyArrangements
import cdm.legaldocumentation.csa.AdditionalRepresentations
import cdm.product.collateral.ContactElection
import cdm.legaldocumentation.csa.TerminationCurrencyAmendment
import cdm.legaldocumentation.csa.MinimumTransferAmountAmendment
import cdm.legaldocumentation.csa.ProcessAgent
import cdm.legaldocumentation.csa.JurisdictionRelatedTerms
import cdm.legaldocumentation.csa.PledgeeRepresentativeRider
import cdm.legaldocumentation.csa.FinalReturns
