# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['BespokeCalculationDate']


class BespokeCalculationDate(BaseDataClass):
    """
    A class to specify bespoke Calculation Date terms for the purposes of Initial Margin.
    """
    isApplicable: bool = Field(..., description="Additional Calculation Date terms are applicable when True and not applicable when False.")
    """
    Additional Calculation Date terms are applicable when True and not applicable when False.
    """
    calculationDateImTerms: Optional[str] = Field(None, description="The Additional Calculation Date terms for the purposes of Initial Margin.")
    """
    The Additional Calculation Date terms for the purposes of Initial Margin.
    """
    
    @rosetta_condition
    def condition_0_CalculationDateImTerms(self):
        """
        A data rule to enforce that Additional Calculation Date Terms should be absent when not applicable.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "calculationDateImTerms")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
