# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AdditionalRightsEvent']


class AdditionalRightsEvent(BaseDataClass):
    """
    A class to specify the Pledgor/Obligor/Chargor Additional Rights Event election.
    """
    isApplicable: bool = Field(..., description="The Pledgor Additional Rights Event election is applicable when True, and not applicable when False.")
    """
    The Pledgor Additional Rights Event election is applicable when True, and not applicable when False.
    """
    qualification: Optional[str] = Field(None, description="The qualification of the Pledgor Additional Rights Event election, when specified.")
    """
    The qualification of the Pledgor Additional Rights Event election, when specified.
    """
    
    @rosetta_condition
    def condition_0_Qualification(self):
        """
        The Pledgor/Obligor/Chargor Additional Rights should be qualified only when the Pledgor Additional Rights Event election is specified as applicable.
        """
        item = self
        def _then_fn0():
            return all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", True)
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "qualification")), _then_fn0, _else_fn0)

import cdm 
