# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AdditionalRepresentation']


class AdditionalRepresentation(BaseDataClass):
    """
    A class to specify the Additional Representation.
    """
    partyElection: List[cdm.legaldocumentation.csa.AdditionalRepresentationElection.AdditionalRepresentationElection] = Field([], description="A qualification as to whether the Additional Representation is applicable.")
    """
    A qualification as to whether the Additional Representation is applicable.
    """
    @rosetta_condition
    def cardinality_partyElection(self):
        return check_cardinality(self.partyElection, 2, None)
    
    customElection: Optional[str] = Field(None, description="A supplemental custom election that might be specified by the parties for the purpose of specifying the Additional Representation.")
    """
    A supplemental custom election that might be specified by the parties for the purpose of specifying the Additional Representation.
    """

import cdm 
import cdm.legaldocumentation.csa.AdditionalRepresentationElection
