# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AccessConditionsElections']


class AccessConditionsElections(BaseDataClass):
    """
    A class to specify the Termination Events that will be deemed an Access Condition or a Specified Condition.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    illegality: bool = Field(..., description="Represents an illegality Termination Event.")
    """
    Represents an illegality Termination Event.
    """
    forceMajeure: bool = Field(..., description="Represents a force Majeure Termination Event.")
    """
    Represents a force Majeure Termination Event.
    """
    taxEvent: bool = Field(..., description="Represents a Tax Termination Event.")
    """
    Represents a Tax Termination Event.
    """
    taxEventUponMerger: bool = Field(..., description="Represents a Tax Event Upon Merger Termination Event.")
    """
    Represents a Tax Event Upon Merger Termination Event.
    """
    creditEventUponMerger: bool = Field(..., description="Represents a Credit Event Upon Merger Termination Event.")
    """
    Represents a Credit Event Upon Merger Termination Event.
    """

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
