# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian

__all__ = ['StringEquals']


@replaceable
def StringEquals(s1: str | None, s2: str | None) -> bool:
    """
    Used by UnitEquals to compare two strings while ignoring the scheme.
    
    Parameters 
    ----------
    s1 : string
    
    s2 : string
    
    Returns
    -------
    result : boolean
    
    """
    self = inspect.currentframe()
    
    
    result =  all_elements(rosetta_resolve_attr(self, "s1"), "=", rosetta_resolve_attr(self, "s2"))
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
